﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.SessionState;
using System.Data;
using System.Text.RegularExpressions;
using DotNet.FrameWork.Common.Encrypt;
using DotNet.FrameWork.Data;
using System.Text;
using System.Data.SqlClient;

namespace HteamDd.Web.ashx
{
    /// <summary>
    /// Dd_do_login 的摘要说明
    /// </summary>
    public class Dd_do_login : IHttpHandler
    {
        HaTeam.Dd.BLL.Dd_User bll = new HaTeam.Dd.BLL.Dd_User();
        HaTeam.Dd.Model.Dd_User model = new HaTeam.Dd.Model.Dd_User();
        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";
            //context.Response.Write("1");
            
            string email = context.Request.Params["email"];
            string password = context.Request.Params["password"];
            string EncryPassword = Encrypt.EncryptPassword(password, "MD5");

            StringWriter sw = new StringWriter();
           
            if (Exists(email,EncryPassword))
            {
                if (user_is_active(email))
                {
                    sw.Write("11" + "," + GetUserName(email));//用户名和密码都正确并且已激活
                }
                else
                {
                    sw.Write("01" + "," + "Error");//标示该用户用户名和密码都正确，但是没有进行激活
                }
            }
            else
            {
                sw.Write("00"+","+"Error");//用户名或密码错误
            }
            HtmlTextWriter htw = new HtmlTextWriter(sw);
            context.Response.Write(sw.ToString());
            context.Response.End();
        }
        public bool Exists(string User_Email,string User_Password)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select count(1) from Dd_User");
            strSql.Append(" where User_Email=@User_Email and User_Passwd=@User_Password");
            SqlParameter[] parameters = {
					new SqlParameter("@User_Email", SqlDbType.NVarChar,50),
                    new SqlParameter("@User_Password",SqlDbType.NVarChar,50)
                                        };
            parameters[0].Value = User_Email;
            parameters[1].Value = User_Password;

            return DbHelperSQL.GetExists(strSql.ToString(), parameters);
        }

        /// <summary>
        /// 根据邮箱账号返回用户的ID和用户的昵称
        /// </summary>
        /// <param name="user_Email"></param>
        /// <returns></returns>
        public string GetUserName(string user_Email)
        {
            string username = string.Empty;
            string sqlUser = "select User_ID,User_BlogName from Dd_User where User_Email='" + user_Email + "'";
            SqlDataReader sdr = DbHelperSQL.ExecuteReader(sqlUser);
            while (sdr.Read())
            {
                username += sdr["User_ID"].ToString() + "," + sdr["User_BlogName"];
            }
            return username;
        }


        /// <summary>
        /// 判断该用户的状态是否已经激活
        /// </summary>
        /// <param name="User_Email">用户的邮箱</param>
        /// <param name="User_Password">用户的密码</param>
        /// <returns> true 该用户已经激活 false 该用户还没有激活</returns>
        public bool user_is_active(string User_Email)
        {
            string active_state = "select User_ActivCondition from Dd_User where User_Email=@email";
            SqlParameter parm = new SqlParameter("@email",SqlDbType.NVarChar,50);
            parm.Value = User_Email;
            int state = Convert.ToInt32(DbHelperSQL.GetSingle(active_state, parm));
            if (state ==1)
            {
                return true;
            }
            else
                return false;
        }
        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}